/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MergingJsonDataLoader<B>
implements class_4013 {
    private static final Logger log = LogManager.getLogger(MergingJsonDataLoader.class);
    private static final int JSON_LENGTH = ".json".length();
    @VisibleForTesting
    protected final Gson gson;
    @VisibleForTesting
    protected final String folder;
    @VisibleForTesting
    protected final Function<class_2960, B> builderConstructor;

    protected abstract void parse(B var1, class_2960 var2, JsonElement var3) throws JsonSyntaxException;

    protected abstract void finishLoad(Map<class_2960, B> var1, class_3300 var2);

    public void method_14491(class_3300 manager) {
        HashMap<class_2960, B> map = new HashMap<class_2960, B>();
        for (Map.Entry filePath : manager.method_41265(this.folder, fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            String path = ((class_2960)filePath.getKey()).method_12832();
            class_2960 id = new class_2960(((class_2960)filePath.getKey()).method_12836(), path.substring(this.folder.length() + 1, path.length() - JSON_LENGTH));
            for (class_3298 resource : (List)filePath.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement json = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                        if (json == null) {
                            log.error("Couldn't load data file {} from {} in data pack {} as its null or empty", (Object)id, filePath, (Object)resource.method_45304().method_14409());
                            continue;
                        }
                        B builder = map.computeIfAbsent(id, this.builderConstructor);
                        this.parse(builder, id, json);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException | RuntimeException ex) {
                    log.error("Couldn't parse data file {} from {} in data pack {}", (Object)id, filePath, (Object)resource.method_45304().method_14409(), (Object)ex);
                }
            }
        }
        this.finishLoad(map, manager);
    }

    public MergingJsonDataLoader(Gson gson, String folder, Function<class_2960, B> builderConstructor) {
        this.gson = gson;
        this.folder = folder;
        this.builderConstructor = builderConstructor;
    }
}

